<?php

namespace App\Controllers;

use ApiResponse;
use App\Controllers\BaseAdminController;
use CodeIgniter\Database\BaseConnection;
use PaginationInfo;
use stdClass;
use TableSql;

class Categorii extends BaseAdminController
{

    public function refresh_info()
    {
        $ret = $this->verify_login();

        if (!$ret->NotLogged) {
            $filters = $this->request->getPost("Filters");
            $order_by = $this->request->getPost("OrderBy");
            $pg_info = new PaginationInfo($this->request->getPost("PaginationInfo"));
            //
            $sql = new TableSql("SELECT t1.* FROM categorii t1 WHERE 'a'='a'  ");
            $sql->addIfNeeded($filters['Nume'], '', " AND t1.Nume LIKE '%%%s%%' ");
            $sql->addLimitFromPagination($pg_info);
            //
            $result = $sql->getResult();
            $rows = $result->Rows;
            foreach($rows as $row){
                $row->Imagine_Url = base_url('api/writable/uploads/' . $row->Imagine);
            }
            //
            $pg_info->RowCount = $result->FullRowsCount;
            $ret->Results = $rows;
            $ret->PaginationInfo = $pg_info;
        }

        return $this->response->setJSON($ret);
    }

    public function get_info()
    {
        $ret = $this->verify_login();

        return $this->response->setJSON($ret);
    }

    public function get_info_dialog()
    {
        $ret = $this->verify_login();

        if (!$ret->NotLogged) {

        }

        return $this->response->setJSON($ret);
    }

    public function get_info_item_dialog()
    {
        $ret = $this->verify_login();

        if (!$ret->NotLogged) {
            $id = $this->request->getPost("id");
            $ret->Item              = $this->db->table("categorii")->where("id", $id)->get()->getFirstRow();
            $ret->Item->Imagine_Url = base_url('api/writable/uploads/' . $ret->Item->Imagine);
        }

        return $this->response->setJSON($ret);
    }

    public function save()
    {
        $ret = $this->verify_login();

        if (!$ret->NotLogged) {
            $mode = $this->request->getPost("mode");
            $item = $this->request->getPost("object");

            $id = -1;

            if (array_key_exists('Imagine_Url', $item)) unset($item['Imagine_Url']);

            if ($mode == "add") {
                if (array_key_exists('Id', $item))
                    unset($item['Id']);
                $this->db->table("categorii")->insert($item); // Schimbați "clienti" cu "categorii"
                $id = $this->db->insertID();
            } else {
                $id = $item['Id'];
                unset($item['Id']);
                $this->db->table("categorii")->where("Id", $id)->update($item); // Schimbați "clienti" cu "categorii"
            }
        }

        return $this->response->setJSON($ret);
    }

    public function delete_item()
    {
        $ret = $this->verify_login();

        if (!$ret->NotLogged) {
            $id = $this->request->getPost("id");
            $this->db->table("categorii")->where("id", $id)->set("Sters", "1")->update(); // Schimbați "clienti" cu "categorii"
        }

        return $this->response->setJSON($ret);
    }

    public function undelete_item()
    {
        $ret = $this->verify_login();

        if (!$ret->NotLogged) {
            $id = $this->request->getPost("id");
            $this->db->table("categorii")->where("id", $id)->set("Sters", "0")->update(); // Schimbați "clienti" cu "categorii"
        }

        return $this->response->setJSON($ret);
    }

    public function upload_imagine()
    {
        $file = $this->request->getFile('file');
        
        if (!$file->isValid()) {
            return $this->response->setJSON(['status' => 'error', 'message' => $file->getErrorString()]);
        }
        
        // Definește un nume aleatoriu sau poți folosi $file->getName() pentru numele original
        $newName = $file->getRandomName();
        
        // Muți fișierul în directorul dorit
        $file->move(WRITEPATH . 'uploads', $newName);

        $url = base_url('api/writable/uploads/' . $newName);

        // Înapoiează un răspuns cu numele fișierului încărcat
        return $this->response->setJSON(['status' => 'success', 'filename' => $newName, 'url' => $url]);
    }
}