
import axios from 'axios';
import { useRouter } from 'vue-router';


export default {
    version: "1.0", 
    BASE_URL: 'https://designer.brk-dev.ro/api',
    set_token: function(nume, email='', token='') {
        window.localStorage.setItem("designer-token" , token );
        window.localStorage.setItem("designer-nume"  , nume  );
        window.localStorage.setItem("designer-email" , email );
        axios.defaults.headers.common = {
            "Token": token
          };
    },
 
    get_nume: function () {
        return window.localStorage.getItem("designer-nume");
    },

    get_email: function () {
        return window.localStorage.getItem("designer-email");
    },

    get_token: function() {
        return window.localStorage.getItem("designer-token");
    },

    is_logged_in: function() {
        var token = this.get_token();
        return token !== "";
    },

    logout: function() {
        this.set_token('');
    },

    is_logged_in: function() {
        var token = this.get_token();
        
        var is_logged = token !== "";
        is_logged = token != null;
        is_logged = token.length > 0;
        
        return is_logged;
    },

    verify_response: function(response) {
        if (response.NotLogged) {
            return false;
        }
        return true;
    },

    redirect_to_homepage(vueInstance){
        vueInstance.$router.push("/");
    },

    verify_login_and_redirect: function(vueInstance) {
        
        if (!this.is_logged_in()) {
            this.redirect_to_homepage(vueInstance);
        }
    },
};
