  
  export class FiltruBase {

    constructor(field) {
      this.field = field;
      this.php   = {
        refresh_info_filtre: '',
        alte_operatiuni_listare :'',
        get_info: '',
        get_info_dialog:'',
        get_info_item_dialog_after:'',
        save_after:'',
        alte_functii:''
      };
      this.vue_list = {
        template_filtre: '',
        filtre_array: '',
        info_array: [],
        after_get_info: ''
      }
      this.vue_dialog = {
        template_fields:'',
        selected_object_campuri: '',
        rules:'',
        clear_fields_code:'',
        after_get_info:'',
      }
      this.init();
    }
    
    init(){
        //override this
    }
    tabs(nr){
      return "\t".repeat(nr);
    }

    static factoryCreateNew(field) {
        var ret = null;
        if( field.Type == "text-simplu"     ) ret = new Filtru_TextSimplu   (field);
        if( field.Type == "numeric"         ) ret = new Filtru_Numeric      (field);
        if( field.Type == "numeric-range"   ) ret = new Filtru_NumericRange (field);
        if( field.Type == "select-enum"     ) ret = new Filtru_SelectEnum   (field);
        if( field.Type == "select-db"       ) ret = new Filtru_SelectDb     (field);
        if( field.Type == "checkbox"        ) ret = new Filtru_Checkbox     (field);
        if( field.Type == "date"            ) ret = new Filtru_Date         (field);
        if( field.Type == "date-range"      ) ret = new Filtru_DateRange    (field);
        if( field.Type == "ora"             ) ret = new Filtru_Ora          (field);
        return ret;
    }
  }

  export class Filtru_TextSimplu extends FiltruBase {
    constructor(field) {
      super(field);
    }

    init(){
        const DbColumn       = this.field.DbColumn;
        const Label          = this.field.Label;
        const ValoareDefault = this.field.ValoareDefault ?? "";
        //
        this.php.refresh_info_filtre  = `$sql->addIfNeeded($filters['${DbColumn}'], '', " AND t1.${DbColumn} LIKE '%%%s%%' ");`;
        this.vue_list.template_filtre = ` 
        <el-col :span='4'>
            <el-form-item label='${Label}' >
                <el-input v-model='Filters.${DbColumn}' />
            </el-form-item>
        </el-col>`;

        this.vue_list.filtre_array = ` ${DbColumn}: '${ValoareDefault}', `;
    }
  }

  export class Filtru_Numeric extends FiltruBase {
    constructor(field) {
      super(field);
    }
  
    init() {
      const DbColumn    = this.field.DbColumn;
      const Label       = this.field.Label;
      const Precizie    = this.field.Precizie;
      const ValoareDefault = this.field.ValoareDefault ?? '';
  
      this.php.refresh_info_filtre = `$sql->addIfNeeded($filters['${DbColumn}'], '', " AND t1.${DbColumn} = '%s' ");`;
      this.vue_list.template_filtre = `
        <el-col :span='4'>
          <el-form-item label='${Label}' >
            <el-input-number v-model='Filters.${DbColumn}' :precision='${Precizie}' :max='999999'/>
          </el-form-item>
        </el-col>`;

      this.vue_list.filtre_array = ` ${DbColumn}: '${ValoareDefault}', `;
    }
  }

  export class Filtru_NumericRange extends FiltruBase {
    constructor(field) {
      super(field);
    }
  
    init() {
      const DbColumn       = this.field.DbColumn;
      const Label          = this.field.Label;
      const Precizie       = this.field.Precizie;
      const ValoareDefault = this.field.ValoareDefault ?? '';
  
      this.php.refresh_info_filtre = `
        $sql->addIfNeeded($filters['${DbColumn}_Min'], '', ' AND t1.${DbColumn} >= %s');
        $sql->addIfNeeded($filters['${DbColumn}_Max'], '', ' AND t1.${DbColumn} <= %s');`;
  
      this.vue_list.template_filtre = `
        <el-col :span='8'>
          <el-form-item label='${Label} Min'>
            <el-input-number v-model='Filters.${DbColumn}_Min' :precision='${Precizie}' :max='999999' />
          </el-form-item>
        </el-col>
        <el-col :span='8'>
          <el-form-item label='${Label} Max'>
            <el-input-number v-model='Filters.${DbColumn}_Max' :precision='${Precizie}' :max='999999' />
          </el-form-item>
        </el-col>
      `;

      this.vue_list.filtre_array = ` ${DbColumn}_Min: '${ValoareDefault}', ${DbColumn}_Max: '${ValoareDefault}', `;
    }
  }

  export class Filtru_SelectEnum extends FiltruBase {
    constructor(field) {
      super(field);
    }
  
    init() {
        const DbColumn = this.field.DbColumn;
        const Label     = this.field.Label;
        const Valori    = this.field.Valori.split("\n");
        const Labels    = this.field.Labels.split("\n");
        const ValoareDefault = this.field.ValoareDefault ?? "";

        this.php.refresh_info_filtre = this.tabs(1) + `$sql->addIfNeeded($filters['${DbColumn}'], '', " AND t1.${DbColumn} = '%s' ");`;

        this.vue_list.template_filtre = `
            <el-col :span='4'>
                <el-form-item label='${Label}'>
                    <el-select v-model='Filters.${DbColumn}'>`
                    + "\n";
        for(var i = 0; i < Valori.length; i++){
            this.vue_list.template_filtre += this.tabs(6) + `<el-option label='${Labels[i]}' value='${Valori[i]}' />` + "\n";;
        }

        this.vue_list.template_filtre += `
                    </el-select>
                </el-form-item>
            </el-col>
        `;

        this.vue_list.filtre_array = ` ${DbColumn}: '${ValoareDefault}', `;
    }
  }

  export class Filtru_SelectDb extends FiltruBase {
    constructor(field) {
      super(field);
    }
  
    init() {
        const DbColumn                      = this.field.DbColumn;
        const Label                         = this.field.Label;
        const Tabel2                        = this.field.Tabel2;
        const ColoanaId                     = this.field.ColoanaId;
        const ColoanaLabel                  = this.field.ColoanaLabel;
        const ValoareDeIgnorat              = this.field.ValoareDeIgnorat;
        const LabelValoareDeIgnorat         = this.field.LabelValoareDeIgnorat;
        const BifamImplicitPrimulElement    = this.field.BifamImplicitPrimulElement;

        this.php.refresh_info_filtre = `
            $sql->addIfNeeded($filters['${DbColumn}'], '${ValoareDeIgnorat}', " AND t1.${DbColumn} = '%s' ");
        `;
        this.php.get_info = `$ret->Info->${Tabel2} = $this->db->table("${Tabel2}")->select("${ColoanaId}, ${ColoanaLabel}")->get()->getResult();`;

        this.vue_list.template_filtre = `
            <el-col :span='4'>
                <el-form-item label='${Label}'>
                    <el-select v-model='Filters.${DbColumn}'>` + "\n";
        
        if(LabelValoareDeIgnorat != '') {
            this.vue_list.template_filtre += this.tabs(6) + `<el-option label='${LabelValoareDeIgnorat}' value='${ValoareDeIgnorat}' />` + "\n";
        }
        
        this.vue_list.template_filtre += this.tabs(6) + 
          `<el-option v-for='(item, index) in Info.${Tabel2}' :key="'item-' + index" :label='item.${ColoanaLabel}' :value='item.${ColoanaId}' />` 
          + "\n";
        
        this.vue_list.template_filtre += `
                    </el-select>
                </el-form-item>
            </el-col>
        `;

        this.vue_list.filtre_array = ` ${DbColumn}: '', `;
        this.vue_list.info_array   = ` ${Tabel2}: [], `;

        if( BifamImplicitPrimulElement )
        {
            this.vue_list.after_get_info = `if ( this.Info.${Tabel2}.length > 0 ) this.Filtre.${DbColumn} = this.Info.${Tabel2}[0].${ColoanaId}; `;
        }
    }
  }

  export class Filtru_Checkbox extends FiltruBase {
    constructor(field) {
      super(field);
    }
  
    init() {
        const DbColumn      = this.field.DbColumn;
        const Label         = this.field.Label;
        const ValoareTrue   = this.field.ValoareTrue;
        const ValoareFalse  = this.field.ValoareFalse;
        const ValoareDefault = this.field.ValoareDefault ?? ValoareFalse;
        

        this.php.refresh_info_filtre = `if( !empty( $filters['${DbColumn}'] ) ) $sql->addIfNeeded($filters['${DbColumn}'], '', " AND t1.${DbColumn} = '%s' ");`;
        this.vue_list.template_filtre = `
            <el-col :span='4'>
                <el-form-item label='${Label}' >
                    <el-checkbox class='full-width' v-model='Filters.${DbColumn}' true-label='${ValoareTrue}' false-label='${ValoareFalse}'> ${Label} </el-checkbox>
                </el-form-item>
            </el-col>
        `;

        this.vue_list.filtre_array = ` ${DbColumn}: '${ValoareDefault}', `;
    }
  }
  
  export class Filtru_Date extends FiltruBase {
    constructor(field) {
      super(field);
    }
  
    init() {
        const DbColumn         = this.field.DbColumn;
        const Label            = this.field.Label;
        const ValoareDefault   = this.field.ValoareDefault ?? '';
        const ValoareDeIgnorat = this.field.ValoareDeIgnorat ?? '';
        const FormatData       = this.field.FormatData;

        this.php.refresh_info_filtre = this.tabs(1) + `$sql->addIfNeeded($filters['${DbColumn}'], '${ValoareDeIgnorat}', " AND t1.${DbColumn} = '%s' ");`;
        
        this.vue_list.template_filtre = `
              <el-col :span='4'>
                  <el-form-item label='${Label}' >
                      <el-date-picker v-model='Filters.${DbColumn}' type='date' value-format='yyyy-MM-dd' format='${FormatData}' />
                  </el-form-item>
              </el-col>
        `;

        this.vue_list.filtre_array = ` ${DbColumn}: '${ValoareDefault}', `;
    }
  }

  export class Filtru_DateRange extends FiltruBase {
    constructor(field) {
      super(field);
    }
  
    init() {
        const DbColumn         = this.field.DbColumn;
        const Label            = this.field.Label;
        const ValoareDeIgnorat = this.field.ValoareDeIgnorat ?? '';
        const FormatData       = this.field.FormatData;

        this.php.refresh_info_filtre = `
              if( !empty( $filters['${DbColumn}'] ) ) 
              {
                $sql->addIfNeeded( $filters['${DbColumn}'][0], '${ValoareDeIgnorat}', \" AND t1.${DbColumn} >= '%s' \");
                $sql->addIfNeeded( $filters['${DbColumn}'][1], '${ValoareDeIgnorat}', \" AND t1.${DbColumn} <= '%s' \");
              }
        `;
        
        this.vue_list.template_filtre = `
              <el-col :span='4'>
                  <el-form-item label='${Label}' >
                      <el-date-picker v-model='Filters.${DbColumn}' type='daterange' value-format='yyyy-MM-dd' format='{${FormatData}' />
                  </el-form-item>
              </el-col>
              
        `;

        this.vue_list.filtre_array = ` ${DbColumn}: '', `;
    }
  }

  export class Filtru_Ora extends FiltruBase {
    constructor(field) {
      super(field);
    }
  
    init() {
        const DbColumn         = this.field.DbColumn;
        const Label            = this.field.Label;
        const FormatOra        = this.field.FormatOra;

        this.php.refresh_info_filtre = this.tabs(1) + `$sql->addIfNeeded($filters['${DbColumn}'], '', " AND t1.${DbColumn} = '%s' ");`;
        
        this.vue_list.template_filtre = `
              <el-col :span='4'>
                  <el-form-item label='${Label}' >
                      <el-time-select v-model='Filters.${DbColumn}' value-format='HH:mm:ss' format='${FormatOra}' />
                  </el-form-item>
              </el-col>
        `;

        this.vue_list.filtre_array = ` ${DbColumn}: '', `;
    }
  }

  export default {
    FiltruBase,
    Filtru_TextSimplu,
    Filtru_Numeric,
    Filtru_NumericRange,
    Filtru_SelectEnum,
    Filtru_SelectDb,
    Filtru_Checkbox,
    Filtru_Date,
    Filtru_DateRange,
    Filtru_Ora
  };