  
  export class ListareBase {

    constructor(field) {
      this.field = field;
      this.php   = {};
      this.vue_list = {
        coloane: ''
      }
      this.vue_dialog = {}
      this.init();
    }
    
    init(){
        //override this
    }
    tabs(nr){
      return "\t".repeat(nr);
    }

    static factoryCreateNew(field) {
        var ret = null;
        if( field.Type == "text-simplu"     ) ret = new Listare_TextSimplu   (field);
        if( field.Type == "currency"        ) ret = new Listare_Currency     (field);
        if( field.Type == "date"            ) ret = new Listare_Date         (field);
        if( field.Type == "time"            ) ret = new Listare_Time         (field);
        if( field.Type == "date-time"       ) ret = new Listare_DateTime     (field);
        return ret;
    }
  }

  export class Listare_TextSimplu extends ListareBase {
    constructor(field) {
      super(field);
    }

    init(){
        const DbColumn       = this.field.DbColumn;
        const Label          = this.field.Label;
        //
        this.vue_list.coloane = `<el-table-column prop='${DbColumn}' label='${Label}'></el-table-column>`;
    }
  }

  export class Listare_Currency extends ListareBase {
    constructor(field) {
      super(field);
    }
  
    init() {
      const DbColumn    = this.field.DbColumn;
      const Label       = this.field.Label;
      const Valuta      = this.field.Valuta;

      this.vue_list.coloane = `
                    <el-table-column prop='${DbColumn}' label='${Label}'>
                        <template #default="scope">
                            {{ scope.row.${DbColumn} }} ${Valuta} 
                        </template>
                    </el-table-column>`;

    }
  }

  export class Listare_Date extends ListareBase {
    constructor(field) {
      super(field);
    }
  
    init() {
      const DbColumn    = this.field.DbColumn;
      const Label       = this.field.Label;
      const FormatData  = this.field.FormatData;

      this.vue_list.coloane = `
                    <el-table-column prop='${DbColumn}' label='${Label}'>
                        <template #default="scope">
                            {{ scope.row.${DbColumn} }} 
                        </template>
                    </el-table-column>`;

    }
  }

  export class Listare_Time extends ListareBase {
    constructor(field) {
      super(field);
    }
  
    init() {
      const DbColumn    = this.field.DbColumn;
      const Label       = this.field.Label;
      const FormatData  = this.field.FormatData;

      this.vue_list.coloane = `
                    <el-table-column prop='${DbColumn}' label='${Label}'>
                        <template #default="scope">
                            {{ scope.row.${DbColumn} }} 
                        </template>
                    </el-table-column>`;

    }
  }

  export class Listare_DateTime extends ListareBase {
    constructor(field) {
      super(field);
    }
  
    init() {
      const DbColumn    = this.field.DbColumn;
      const Label       = this.field.Label;
      const FormatData  = this.field.FormatData;

      this.vue_list.coloane = `
                    <el-table-column prop='${DbColumn}' label='${Label}'>
                        <template #default="scope">
                            {{ scope.row.${DbColumn} }} 
                        </template>
                    </el-table-column>`;

    }
  }


  export default {
    ListareBase,
    Listare_TextSimplu,
    Listare_Currency,
    Listare_Date,
    Listare_Time,
    Listare_DateTime
  };