import './assets/main.css'

import { createApp } from 'vue'
import App from './App.vue'
import router from './router'
import ElementPlus from 'element-plus'
import * as ElementPlusIconsVue from '@element-plus/icons-vue';
import { QuillEditor } from '@vueup/vue-quill'
import '@vueup/vue-quill/dist/vue-quill.snow.css';
import 'element-plus/dist/index.css'
import { VCodeBlock } from '@wdns/vue-code-block';


  

const app = createApp(App)
app.use(router)
app.use(ElementPlus)

app.component('VCodeBlock', VCodeBlock);
app.component('QuillEditor', QuillEditor)


for (const [key, component] of Object.entries(ElementPlusIconsVue)) {
    app.component(key, component);
}



app.mount('#app')
